--
-- Copyright (C) 2005 dahua Technologies, All Rights Reserved.
-- 2006-4-25 15:54 Z:\wjj\ven\152\DAHUA\Install.lua
-- 2006-9-21  modified by zhongjl for new partition
--

-- Flash ĴСΪ128K
local flashSectorSize = 0x20000;

local Installer = {};
Installer.TotalSize      = 0;    -- ܵҪдFlashеݴС
Installer.InProgressSize = 0;	 -- пƽ

-- ֪ͨϲӦóĽϢ
-- params:
--    
-- return:
--    
function Installer:notify()
	self.InProgressSize = self.InProgressSize + flashSectorSize;

	local progress = self.InProgressSize / self.TotalSize * 100;
	if(progress > 100) then
		progress = 100;
	end;
	progress = tonumber(string.format("%d", progress));

	-- ע÷ʽ,self::callback,ᵼ»ص
	self.callback(0x01, progress);
end

-- ȫ߰汾У
-- params:
--    
-- return:
--    ɹTrue, ʧܷFalseԼʧܵԭ
function Installer:checkSecurityBaselineVersion()
	local defVersion = "V1.4";
	local curVersion = Global.Vendor.SecurityBaselineVersion;
	--а汾ϢҪֶ£config.luaеSecurityBaselineVersionһ
	local newVersion = "V1.4";
	
	if (type(curVersion) ~= "nil") then
		--ַİȫ߰汾ϢתΪӦ
		--Ŀǰְ֧ȫ߰汾ϢʽVx.x
		--氲ȫ߰汾Ϣʽת߼ҪӦ
		
		local sPos;
		local ePos;
		
		local defMainVerStr;
		local defSubVerStr;
		sPos, ePos, defMainVerStr, defSubVerStr = string.find(defVersion, "V(%d+)%.(%d+)");
		local defMainVerNum = tonumber(defMainVerStr);
		local defSubVerNum = tonumber(defSubVerStr);
		
		local curMainVerStr;
		local curSubVerStr;
		sPos, ePos, curMainVerStr, curSubVerStr = string.find(curVersion, "V(%d+)%.(%d+)");
		local curMainVerNum = tonumber(curMainVerStr);
		local curSubVerNum = tonumber(curSubVerStr);
		
		local newMainVerStr;
		local newSubVerStr;
		sPos, ePos, newMainVerStr, newSubVerStr = string.find(newVersion, "V(%d+)%.(%d+)");
		local newMainVerNum = tonumber(newMainVerStr);
		local newSubVerNum = tonumber(newSubVerStr);
		
		if (type(defMainVerNum) == "nil" or type(defSubVerNum) == "nil" or type(curMainVerNum) == "nil" or type(curSubVerNum) == "nil" or type(newMainVerNum) == "nil" or type(newSubVerNum) == "nil") then
			print(string.format("Error defVersion:%s, curVersion:%s, newVersion:%s", defVersion, curVersion, newVersion));
			return false, "Invalid version";
		end
		
		print(string.format("Checking SecurityBaselineVersion defVersion:%s(%d %d), curVersion:%s(%d %d), newVersion:%s(%d %d)", defVersion, defMainVerNum, defSubVerNum, curVersion, curMainVerNum, curSubVerNum, newVersion, newMainVerNum, newSubVerNum));
		
		if(((newMainVerNum < defMainVerNum) or (newMainVerNum == defMainVerNum and newSubVerNum < defSubVerNum)) and ((curMainVerNum > defMainVerNum) or (curMainVerNum == defMainVerNum and curSubVerNum >= defSubVerNum))) then
			return false, "Invalid version";
		end
	else
		print("curVersion nil");
	end
	
	return true;
end

-- ӦóṩϢжǷ
-- params:
--    
-- return:
--    ɹTrue, ʧܷFalseԼʧܵԭ
function Installer:preInstall()
	-- ҪЩ
	-- Ӳ汾 
	-- ԭİ汾ţ
	--
	local board = Global.Hardware.board;
	local hwproduct;
	local hwchannel;
	local hwversion;
	local hwfunction;

	print(string.format("Checking hardware information,board name:%s version:%s",
		board.name, board.version));
	if(board.name ~= "NVR5X-4K") then
		return false, "Invalid board";
	end

	--ֱӴӲȡֵ
	--hwproductȡֵ: 2 -- LB; 3 -- LBN; 4 -- LB_ATM; 5 -- GBE; 6 -- LK; 7 -- LS
	--hwproductȡֵ: 2 -- IPC4X5; 3 -- A6; 4 -- A8; 5 -- IPVM;
	--hwchannelȡֵ: x -- x chans
	--hwfunctionȡֵ: 0 -- AUDIO; 1 -- MATRIX; 3 -- LOOP

	if(mtd.getinfo)then
		hwproduct,hwchannel,hwversion,hwfunction = mtd.getinfo();
		print(string.format("Checking hardware id info: product = %x; channel = %x; version = %x; function = %x",
			hwproduct,hwchannel,hwversion,hwfunction));
		if((hwproduct ~= 3) and (hwproduct ~= 4)) then
			print(string.format("product not match"));
			return false, "Invalid board";
		end
	end

	-- ҪУ鲻ͬ屾İӳǷͨ,
	-- ĿǰLB 1.22 LB 2.00İӾͲͨ
	-- if(board.version ~= "1.22") then
	--  print(string.format("XXXXXXXXXXXX"));
	--	return false, "Invalid board version";
	-- end

	local vendor = Global.Vendor;

	print(string.format("Checking vendor information,vendor name:%s", vendor.Name));
	if(vendor.Name ~= 'NVR5X-4K' and vendor.Name ~= 'DAHUA') then
		return false, "Invalid vendor";
	end
	
	local ret, info = self:checkSecurityBaselineVersion();
	if(not ret) then
		return false, info;
	end
	
	local curRegion = Global.VersionAreaInformation;
	
	--"Inland"; "Abroad"
	local newRegion = "Abroad";

	if(type(curRegion) == "nil") then
		print(string.format("Checking VersionAreaInformation, curRegion:nil, newRegion:%s", newRegion));
	else
		print(string.format("Checking VersionAreaInformation, curRegion:%s, newRegion:%s", curRegion, newRegion));
	end
	
	--curRegionΪգʾϳȫV1.4ϣԭԣ
	--curRegionΪգʾȫV1.4ϵĳ²ԣƹں⻥
	if(type(curRegion) ~= "nil" and curRegion ~= newRegion) then
		return false, "Regional conflict";
	end

	return true;
end

-- ɺĴ,ϵͳ
-- params:
--    
-- return:
--    
function Installer:postInstall()
end

-- Flash,ڲͬӦ,Ĵܲһ
-- params	:
-- part		: ,ʼλԼλ
-- filename	: еļ
-- return	: 
function Installer:updatePart(part, filename)
	local myfile = self.ZipArchive:open(filename);
	local write_times = 0;
	-- ļ򲻿,ҪԴ˲ֽ
	if(not myfile) then
		print(string.format("%s not exist", filename));
		return ;
	end

	local addr   = part.baseAddr;
	local endAddr= part.endAddr;
	local data;
	local fldata;
	local write_times1 = 0;
	
	print(string.format("Start Update : %s ", filename));
	-- ǰ64ֽڵͷ,µ汾вҪԴ˽У
	myfile:seek("set", 64);
	while(addr < endAddr) do
	
		fldata = mtd.read(addr,flashSectorSize);
		data = myfile:read(flashSectorSize);    -- һFlashС
		-- if (fldata and data and (fldata ~= data)) then
		-- fldataΪյʱΪϵĳֱӲ

		if(data) then
			if((not fldata) or (data and (fldata ~= data))) then
				mtd.erase(addr);
				mtd.write(addr, data);
				write_times = write_times+1;
				fldata = mtd.read(addr,flashSectorSize);
				if((not fldata) or (data and (fldata ~= data))) then
					mtd.erase(addr);
					mtd.write(addr, data);
					write_times1 = write_times1 + 1;
				end			
			end
		  self:notify();
		  addr   = addr   + flashSectorSize;
		else
		  addr = endAddr;
		end
	end
	print(string.format("==========> Write Times : %s  write_times1 : %s<==========", write_times, write_times1));
	myfile:close();
end

function Installer:InstallPlayer(filename)
	local myfile = self.ZipArchive:open(filename);

	-- ļ򲻿,ҪԴ˲ֽ
	if(not myfile) then
		return ;
	end

	--
	-- TODO:
	-- ԶݣͨIDEӿд뵽Ӳ
	--
end

--ѹimgļУ飬Уȷ1󷵻0
function Installer:crc32check( filename)
	local myfile = self.ZipArchive:open(filename);
	
	-- ļ򲻿(޴ļ),ҪԴ˲ֽ
	if(not myfile) then
		print(string.format("==>Installer:crc32check not myfile %s , no need to check", filename));
		return 1;
	end
	
	-- ӦóУӿ,У飬ֱӷسɹԼǰӦó
	if(not mtd.check_init) then
		print(string.format("==>Installer:crc32check not mtd.check_init, no need to check") );
		return 1	
	end	
	if(not mtd.crc32)then
		print(string.format("==>Installer:crc32check not mtd.crc32, no need to check"));
		return 1
	end
	
	local head = myfile:read(64);--64ֽڵͷ
	
	local filesize = 0;
	local filecrc32 = 0;
	print(string.format("==>Installermtd.check_init"));
	filesize, filecrc32 = mtd.check_init(head);-- ʼ
	print(string.format("==>Installer mtd.check_init over, filesize:%d filecrc:%x!", filesize, filecrc32));
	local checksum = 0;
	local readlen =0;
	local data;
	-- ݲּУ
	while (readlen < filesize) do
		data = myfile:read(flashSectorSize);
		--print(string.format("Installer check crc32:%x ------%x!", checksum, readlen) );
		if (filesize - readlen < flashSectorSize) then
			checksum = mtd.crc32(checksum, data, filesize - readlen)
		else
			checksum = mtd.crc32(checksum, data, flashSectorSize)
		end
		readlen = readlen + flashSectorSize;
	end

	if (checksum ~= filecrc32) then
		print(string.format("==>error: Installer check (%s)crc32 error:%x ------%x!", filename, checksum, filecrc32));
		return 0;
	end
	print(string.format("==>correct: Installer check(%s) crc32 correct:%x ------%x!", filename, checksum, filecrc32));
	return 1;
end


function Installer:do_cmd(cmd)
	local ret;
	if (mtd.run_cmd) then
		ret = mtd.run_cmd(cmd);
		print(string.format("Installer:do_cmd mtd.run_cmd cmd=%s ret=%d \n", cmd, ret));
	else
		ret = os.execute(cmd);
		print(string.format("Installer:do_cmd os.execute cmd=%s ret=%d \n", cmd, ret));
	end
	return ret == 0;
end

-- 
-- params:
--    
-- return:
--    ɹTrue,ʧܷFlaseԼԭ
function Installer:execute()
	--[[
	 Ϣ,֪ʶ "Flash 滮"
	 0xa0000000  0xa0040000  256K     armboot                                 u-boot
	 0xa0060000  0xa0460000  4096K    kernel + root                           romfs
	 0xa0460000  0xa0a60000  6144K    application + modules                   user
	 0xa0a60000  0xa0c60000  1536K    web                                     web
	 0xa0c60000  0xa0e60000  2560K    slave:romfs + kernel + pcidriver        slave
	 0xa0e60000  0xa0e80000  128K     custom                                  custom
	 0xa0e80000  0xa0ec0000  256K     logo                                    logo
	 0xa0ec0000  0xa0f40000  1024K    config                                  
	 0xa0f40000  0xa1000000  1024K    config1
	]]

	local flashPartions =
	{
		resever		= { baseAddr = 0xa0000000  , endAddr = 0xa0100000 },	--// 1M
		updateflag	= { baseAddr = 0xa0100000  , endAddr = 0xa0200000 },	--// 1M
		boot		= { baseAddr = 0xa0200000  , endAddr = 0xa0300000 },	--// 1M boot
		uImage		= { baseAddr = 0xa0300000  , endAddr = 0xa0700000 },	--// 4M uImage
		rootfs		= { baseAddr = 0xa0700000  , endAddr = 0xa2100000 },	--// 26M rootfs 
		bootslave	= { baseAddr = 0xa2100000  , endAddr = 0xa2200000 },	--// 1M bootslave 
		uImageslave	= { baseAddr = 0xa2200000  , endAddr = 0xa2500000 },	--// 3M uImageslave 
		rootfsslave	= { baseAddr = 0xa2500000  , endAddr = 0xa3300000 },	--// 14M rootfsslave 		
		web			= { baseAddr = 0xa3300000  , endAddr = 0xa3800000 },	--// 5M  web
		custom  	= { baseAddr = 0xa3800000  , endAddr = 0xa3a00000 },	--// 2M custom
		logo		= { baseAddr = 0xa3a00000  , endAddr = 0xa3c00000 },	--// 2M logo	
		config		= { baseAddr = 0xa3c00000  , endAddr = 0xa3f00000 },	--// 3M config
		pmfirmware  = { baseAddr = 0xa3f00000  , endAddr = 0xa3f40000 },    --// 256K pmfirmware
		misc		= { baseAddr = 0xa3f40000  , endAddr = 0xa4000000 },	--// 768K misc 
        web2		= { baseAddr = 0xa4000000  , endAddr = 0xa5400000 },	--// 20M web2	
		rootfs2		= { baseAddr = 0xa5400000  , endAddr = 0xa7200000 },	--// 30M rootfs2 
		config2     = { baseAddr = 0xa7200000  , endAddr = 0xa7c00000 },    --// 10M cinfg2 
        resever2    = { baseAddr = 0xa7c00000  , endAddr = 0xa7f40000 },    --// 3M256K cinfg2 
		misc_backup	= { baseAddr = 0xa7f40000  , endAddr = 0xa8000000 },	--// 768K misc_backup

	}

	-- self.ZipArchive ⲿ,ûóӦе
	assert(self.ZipArchive);
	local zfile = self.ZipArchive;

	local ret, info = self:preInstall();
	if(not ret) then
		return false, info;
	end

	-- ҪļСԼӡļ嵥
	local TotalSize = 0;
	print("==>Files in archive");
	for file in zfile:files() do
		print(file.filename);
		if ("Install.lua" == file.filename or "install.lua" == file.filename) then			
			print("Install.lua need removed!"); 
		else
			TotalSize = TotalSize + file.uncompressed_size;
		end
		
	end
	self.TotalSize  = TotalSize;     -- ܵļС
		
	--ɾ֤ͷ֤,ڸ¸֤ͷ֤(/usr/bin/sslĿ¼)
	--ɾҪmtd.init֮ǰ
	local cmd = "rm -rf /mnt/mtd/ssl";
	if (false == self:do_cmd(cmd)) then
		return false, "do_cmd error";
	end	
	
	mtd.init();

	if ( 1 ~= (self:crc32check("u-boot.bin.img"))
		or 1 ~= (self:crc32check("uImage.img"))
	    or 1 ~= (self:crc32check("romfs-x.squashfs.img")) 
		or 1 ~= (self:crc32check("u-boot_slave.bin.img"))
		or 1 ~= (self:crc32check("uImage_slave.img"))
	    or 1 ~= (self:crc32check("romfs_slave-x.squashfs.img"))
	    or 1 ~= (self:crc32check("web-x.squashfs.img"))		
	    or 1 ~= (self:crc32check("custom-x.squashfs.img"))
	    or 1 ~= (self:crc32check("logo-x.squashfs.img")) 
        or 1 ~= (self:crc32check("user-x.squashfs.img"))
        or 1 ~= (self:crc32check("575S_PMX.bin.img")) 
        or 1 ~= (self:crc32check("romfs2-x.squashfs.img")) 
         ) then
		print("==>Upgrade: crc32check error!");
		return false;
	end

	self:updatePart(flashPartions["boot"],	"u-boot.bin.img");
	--mtd.saveenv();
	self:updatePart(flashPartions["uImage"],	"uImage.img");
	self:updatePart(flashPartions["rootfs"],	"romfs-x.squashfs.img");
	--self:updatePart(flashPartions["user"],		"user-x.squashfs.img");
	self:updatePart(flashPartions["bootslave"],		"u-boot_slave.bin.img");
	self:updatePart(flashPartions["uImageslave"],		"uImage_slave.img");
	self:updatePart(flashPartions["rootfsslave"],		"romfs_slave-x.squashfs.img");
	self:updatePart(flashPartions["web"],		"web-x.squashfs.img");
	self:updatePart(flashPartions["custom"],	"custom-x.squashfs.img");
	--logoҪӺжϣԿͻԶlogoɾ
	--self:updatePart(flashPartions["logo"],		"logo-x.squashfs.img"); 
	self:updatePart(flashPartions["pmfirmware"],          "575S_PMX.bin.img");
    self:updatePart(flashPartions["rootfs2"],	"romfs2-x.squashfs.img");
	--self:InstallPlayer("autoplayer.bin");


	-- 豸logoĬϲӦóãEraseLogoΪⲿ
	-- δô˱־logoд
	if ((type(self.EraseLogo) == 'nil') or self.EraseLogo) then
		print(string.format("==>correct: Installer EraseLogo executed!"));
		self:updatePart(flashPartions["logo"],		"logo-x.squashfs.img");
	end
	print(string.format("==>correct: Installer EraseLogo%s!", tostring(self.EraseLogo)));
	self:postInstall();
	
	print("==>Upgrade finished");
	return true;
end

return Installer;
